version 10
clear
set more off
cd "C:\Users\Andrew\My publications\Aust - elections & local unemp\Fundamental Attribution Error & State Elections\"

* This dofile is written to accompany this paper:
* Andrew Leigh & Mark McLeish, 2009, "Are State Elections Affected by the National Economy? Evidence from Australia", Economic Record
* Any use of the data or dofile should cite that paper. 
* Questions should be directed to andrew_leigh@ksg02.harvard.edu.

* There are two dofiles - one to set up the data, and one to run the regressions. The regressions dofile will run independently, as the
* files provided in the zipfile include temp_elections.dta.

***************************************
* Regressions
***************************************
use temp_elections, clear

* Summary stats
for num 1/0: tabstat u du u_rest du_rest if ch_gov==X,by(state)
for num 1/0: tabstat u if ch_gov==X,by(state) stat(n)

tabstat u du u_rest du_rest ,by(state)
tabstat u,by(state) stat(n)
tabstat ch_gov u, by(state)

* Regressions
ren same_fed message
xi: reg ch_gov u honeymoon alp message i.state, r
outreg using results.doc, coefastr nocons bracket 3aster replace bdec(3) se ct("U") 
xi: reg ch_gov du honeymoon alp message i.state, r
outreg using results.doc, coefastr nocons bracket 3aster append bdec(3) se ct("dU") 
xi: areg ch_gov u honeymoon alp message i.state , r a(bizcycle)
outreg using results.doc, coefastr nocons bracket 3aster append bdec(3) se ct("U (cycle FE)") 
xi: areg ch_gov du honeymoon alp message i.state , r a(bizcycle)
outreg using results.doc, coefastr nocons bracket 3aster append bdec(3) se ct("du (cycle FE)") 

* Robustness check - including lagged unemployment, ie. u(t-1)
gen u_lag=u-du
xi: reg ch_gov u u_lag honeymoon alp message i.state, r
xi: areg ch_gov u u_lag honeymoon alp message i.state , r a(bizcycle)

* Robustness check - looking at inflation (outreg used only for creating response to referees document)
xi: reg ch_gov u i honeymoon alp message i.state, r
*outreg using results.doc, coefastr nocons bracket 3aster append bdec(3) se ct("robustness check") 
xi: reg ch_gov du di honeymoon alp message i.state, r
*outreg using results.doc, coefastr nocons bracket 3aster append bdec(3) se ct("robustness check") 
xi: areg ch_gov u i honeymoon alp message i.state , r a(bizcycle)
*outreg using results.doc, coefastr nocons bracket 3aster append bdec(3) se ct("robustness check") 
xi: areg ch_gov du di honeymoon alp message i.state , r a(bizcycle)
*outreg using results.doc, coefastr nocons bracket 3aster append bdec(3) se ct("robustness check") 

* Robustness check - interacting u & ALP (outreg used only for creating response to referees document)
gen u_alp=u*alp
gen du_alp=du*alp
xi: reg ch_gov u u_alp honeymoon alp message i.state, r
*outreg using results.doc, coefastr nocons bracket 3aster append bdec(3) se ct("robustness check") 
xi: reg ch_gov du du_alp honeymoon alp message i.state, r
*outreg using results.doc, coefastr nocons bracket 3aster append bdec(3) se ct("robustness check") 
xi: areg ch_gov u u_alp honeymoon alp message i.state , r a(bizcycle)
*outreg using results.doc, coefastr nocons bracket 3aster append bdec(3) se ct("robustness check") 
xi: areg ch_gov du du_alp honeymoon alp message i.state , r a(bizcycle)
*outreg using results.doc, coefastr nocons bracket 3aster append bdec(3) se ct("robustness check") 

* Specification check - does time in power matter?
bysort state (year): egen electionno=seq()
egen stateno=group(state)
tsset stateno electionno
gen timeinpower=year-l.year if l.ch_gov==1
replace timeinpower=year-l2.year if l.ch_gov==0 & l2.ch_gov==1
replace timeinpower=year-l3.year if l.ch_gov==0 & l2.ch_gov==0 & l3.ch_gov==1
replace timeinpower=year-l4.year if l.ch_gov==0 & l2.ch_gov==0 & l3.ch_gov==0 & l4.ch_gov==1
replace timeinpower=year-l5.year if l.ch_gov==0 & l2.ch_gov==0 & l3.ch_gov==0 & l4.ch_gov==0 & l5.ch_gov==1
replace timeinpower=year-l6.year if l.ch_gov==0 & l2.ch_gov==0 & l3.ch_gov==0 & l4.ch_gov==0 & l5.ch_gov==0 & l6.ch_gov==1
replace timeinpower=year-l7.year if l.ch_gov==0 & l2.ch_gov==0 & l3.ch_gov==0 & l4.ch_gov==0 & l5.ch_gov==0 & l6.ch_gov==0 & l7.ch_gov==1
replace timeinpower=year-l8.year if l.ch_gov==0 & l2.ch_gov==0 & l3.ch_gov==0 & l4.ch_gov==0 & l5.ch_gov==0 & l6.ch_gov==0 & l7.ch_gov==0 & l8.ch_gov==1
replace timeinpower=year-l9.year if l.ch_gov==0 & l2.ch_gov==0 & l3.ch_gov==0 & l4.ch_gov==0 & l5.ch_gov==0 & l6.ch_gov==0 & l7.ch_gov==0 & l8.ch_gov==0 & l9.ch_gov==1
replace timeinpower=year-l10.year if l.ch_gov==0 & l2.ch_gov==0 & l3.ch_gov==0 & l4.ch_gov==0 & l5.ch_gov==0 & l6.ch_gov==0 & l7.ch_gov==0 & l8.ch_gov==0 & l9.ch_gov==0 & l10.ch_gov==1
replace timeinpower=year-l11.year if l.ch_gov==0 & l2.ch_gov==0 & l3.ch_gov==0 & l4.ch_gov==0 & l5.ch_gov==0 & l6.ch_gov==0 & l7.ch_gov==0 & l8.ch_gov==0 & l9.ch_gov==0 & l10.ch_gov==0 & l11.ch_gov==1
replace timeinpower=7 if year==1917 & state=="nsw"
replace timeinpower=9 if year==1917 & state=="vic"
replace timeinpower=3 if year==1918 & state=="sa"
replace timeinpower=6 if year==1917 & state=="wa"
replace timeinpower=year-1912 if year>=1916 & year<=1919 & state=="tas"
replace timeinpower=year-1915 if year>=1918 & year<=1929 & state=="qld"
replace timeinpower=year-1989 if year>=1989 & year<=1995 & state=="act"
replace timeinpower=year-1977 if year>=1980 & year<=2001 & state=="nt"
list year state if timein==. & state~=""
gen timeinsq=timeinpower^2
xi: reg ch_gov u honeymoon timein* alp message i.state, r
xi: reg ch_gov du honeymoon timein* alp message i.state, r
xi: areg ch_gov u honeymoon timein* alp message i.state , r a(bizcycle)
xi: areg ch_gov du honeymoon timein* alp message i.state , r a(bizcycle)
drop timein*

gen luck=u_rest
gen dluck=du_rest
gen comp=u-u_rest
gen dcomp=du-du_rest

xi: reg ch_gov luck comp honeymoon alp message i.state, r
test luck=comp
outreg using results.doc, coefastr nocons bracket 3aster append bdec(3) se ct("Levels") addstat("P-val on luck=comp",r(p))
xi: reg ch_gov dluck dcomp honeymoon alp message i.state, r
test dluck=dcomp
outreg using results.doc, coefastr nocons bracket 3aster append bdec(3) se ct("Diffs ") addstat("P-val on luck=comp",r(p))
xi: areg ch_gov luck comp honeymoon alp message i.state , r a(bizcycle)
test luck=comp
outreg using results.doc, coefastr nocons bracket 3aster append bdec(3) se ct("Levels (cycle FE)") addstat("P-val on luck=comp",r(p))
xi: areg ch_gov dluck dcomp honeymoon alp message i.state , r a(bizcycle)
test dluck=dcomp
outreg using results.doc, coefastr nocons bracket 3aster append bdec(3) se ct("Diffs (cycle FE)") addstat("P-val on luck=comp",r(p))

* Note that if we run u and u_rest, the only difference is the coefficient on competence
xi: reg ch_gov luck comp honeymoon alp message i.state, r
xi: reg ch_gov u_rest u honeymoon alp message i.state, r
* b1*u_rest + b2(u-u_rest) = (b1-b2)u_rest + b2u

* What does the ratio look like?
gen compratio=u/u_rest
xi: reg ch_gov luck compratio honeymoon alp message i.state, r
xi: areg ch_gov luck compratio honeymoon alp message i.state , r a(bizcycle)

* Wooldridge (2002) suggests that a straightforward check on the linear probability model is to see how many of the fitted values do not lie between zero and one. 
xi: reg ch_gov u honeymoon alp message i.state, r
predict ch_gov_hat1 if e(sample)
xi: reg ch_gov du honeymoon alp message i.state, r
predict ch_gov_hat2 if e(sample)
xi: reg ch_gov u honeymoon alp message i.state i.bizcycle, r 
predict ch_gov_hat3 if e(sample)
xi: reg ch_gov du honeymoon alp message i.state i.bizcycle, r 
predict ch_gov_hat4 if e(sample)
xi: reg ch_gov luck comp honeymoon alp message i.state, r
predict ch_gov_hat5 if e(sample)
xi: reg ch_gov dluck dcomp honeymoon alp message i.state, r
predict ch_gov_hat6 if e(sample)
xi: reg ch_gov luck comp honeymoon alp message i.state i.bizcycle, r 
predict ch_gov_hat7 if e(sample)
xi: reg ch_gov dluck dcomp honeymoon alp message i.state i.bizcycle, r 
predict ch_gov_hat8 if e(sample)
for num 1/8: sum ch_gov_hatX if ch_gov_hatX>1 | ch_gov_hatX<0
qui drop ch_gov_hat*

* Compare logit
qui xi: logit ch_gov luck comp honeymoon alp message i.state , r
mfx,var(luck comp)
qui xi: logit ch_gov luck comp honeymoon alp message i.state i.bizcycle , r
mfx,var(luck comp)
qui xi: logit ch_gov dluck dcomp honeymoon alp message i.state , r
mfx,var(dluck dcomp)
qui xi: logit ch_gov dluck dcomp honeymoon alp message i.state i.bizcycle , r
mfx,var(dluck dcomp)

xi: ivreg2 ch_gov (luck=us_unemp) comp honeymoon alp message i.state, r first
test luck=comp
outreg using results.doc, coefastr nocons bracket 3aster append bdec(3) se ct("Levels - US IV") addstat("R2",e(r2),"P-val on luck=comp",r(p)) adec(2)
xi: ivreg2 ch_gov (dluck=dus_unemp) dcomp honeymoon alp message i.state, r first
test dluck=dcomp
outreg using results.doc, coefastr nocons bracket 3aster append bdec(3) se ct("Diffs - US IV") addstat("R2",e(r2),"P-val on luck=comp",r(p)) adec(2)
xi: ivreg2 ch_gov (luck=us_unemp) comp honeymoon alp message i.state i.bizcycle, r first
test luck=comp
outreg using results.doc, coefastr nocons bracket 3aster append bdec(3) se ct("Levels (cycle FE) - US IV") addstat("R2",e(r2),"P-val on luck=comp",r(p)) adec(2)
xi: ivreg2 ch_gov (dluck=dus_unemp) dcomp honeymoon alp message i.state i.bizcycle, r first
test dluck=dcomp
outreg using results.doc, coefastr nocons bracket 3aster append bdec(3) se ct("Diffs (cycle FE) - US IV") addstat("R2",e(r2),"P-val on luck=comp",r(p)) adec(2)

* Testing with UK unemp
xi: ivreg2 ch_gov (luck=uk_unemp) comp honeymoon alp message i.state, r first
outreg using results.doc, coefastr nocons bracket 3aster append bdec(3) se ct("Levels - UK IV") addstat("R2",e(r2)) adec(2)
xi: ivreg2 ch_gov (dluck=duk_unemp) dcomp honeymoon alp message i.state, r first
outreg using results.doc, coefastr nocons bracket 3aster append bdec(3) se ct("Diffs - UK IV") 
xi: ivreg2 ch_gov (luck=uk_unemp) comp honeymoon alp message i.state i.bizcycle, r first
outreg using results.doc, coefastr nocons bracket 3aster append bdec(3) se ct("Levels (cycle FE) - UK IV") 
xi: ivreg2 ch_gov (dluck=duk_unemp) dcomp honeymoon alp message i.state i.bizcycle, r first
outreg using results.doc, coefastr nocons bracket 3aster append bdec(3) se ct("Diffs (cycle FE) - UK IV") 

* Robustness check - u rate in other states interacted with current u rate
xi: reg ch_gov u u_rest_sameparty u_rest_diffparty honeymoon alp message i.state, r
test u_rest_sameparty=u_rest_diffparty
outreg using results.doc, coefastr nocons bracket 3aster append bdec(3) se ct("Levels") addstat("P-val on sameparty=diffparty",r(p))
xi: areg ch_gov u u_rest_sameparty u_rest_diffparty honeymoon alp message i.state , r a(bizcycle)
test u_rest_sameparty=u_rest_diffparty
outreg using results.doc, coefastr nocons bracket 3aster append bdec(3) se ct("Levels (cycle FE)") addstat("P-val on sameparty=diffparty",r(p))

*******************************************
* Graphs
******************************************

cd "C:\Users\Andrew\My publications\Aust - elections & local unemp\Fundamental Attribution Error & State Elections\"

use temp_elections, clear
for num 5: gen yearX=X*int(year/X) \ bysort yearX: egen ch_govX=mean(ch_gov) \ egen tag=tag(yearX) \ keep if tag \ keep yearX ch_govX \ sort yearX
save temp_elections_forgraph, replace

use aust_butlin_unemployment if year>=1913 & year<=2006, clear
replace aust_unemp=aust_unemp/100
for num 5: gen yearX=X*int(year/X) \ sort yearX \ merge yearX using temp_elections_forgraph
set scheme s1mono
la var ch_gov "Share of state governments losing elections (bars)"
la var aust_unemp "Australian national unemployment rate (line)"
tw bar ch_gov5 year,yaxis(2)  || line aust_unemployment year,yaxis(1) ysc(r(0 1) axis(2)) ylab(0(.2)1, axis(2)) lpattern(solid) lwidth(medthick) lcolor(black) xti("") legend(off) ti("Fig 1: Australian state elections and national unemployment") xsize(6.5)
graph export fig1.wmf,replace
graph export fig1.eps,replace
graph save fig1.gph,replace

use us_unemployment if year>=1913, clear
replace us_unemp=us_unemp/100
for num 5: gen yearX=X*int(year/X) \ sort yearX \ merge yearX using temp_elections_forgraph
set scheme s1mono
la var ch_gov "Share of state governments losing elections (bars)"
la var us_unemp "US unemployment rate (line)"
tw bar ch_gov5 year,yaxis(2)  || line us_unemployment year,yaxis(1) ysc(r(0 1) axis(2)) ylab(0(.2)1, axis(2)) lpattern(solid) lwidth(medthick) lcolor(black) xti("") legend(off) ti("Fig 2: Australian state elections and US unemployment") xsize(6.5)
graph export fig2.wmf,replace
graph export fig2.eps,replace
graph save fig2.gph,replace

